/*
 *  LICENSE:
 *  Copyright (c) 2008 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 *  
 *
 *  File: $Id: deb_tools.h,v 1.4 2008/08/01 20:57:20 b17778 Exp $
 *
 */

/**
 *	\brief		prints hex memory 
 *				
 *	\param[in]  pInput - Pointer to the memory to be printed
 *	\param[in]	length - number of bytes to be printed
 *						  
 *	\return		none
 *
 *	This function uses the CPrint funtion to print memory to a console
 */
void printmem(void* pInput, int length);


/**
 *	\brief		Converts a signed integer to a zero terminated string
 *				
 *	\param[in]  i - the signed integer to be converted
 *	\param[out]	buf - a pointer to a buffer where the string will be wrote to
 *  \param[in]  len - the size of the buffer in bytes
 *						  
 *	\return		A pointer to the first char of the zero terminated string representing the integer
 *
 *	
 */
char* inttostr(int i, char *buf, int len);
